;
; Oracomm Emulation Control File
;
; This file is designed to provide emulation of Oracomm chat functionality.
; It does not necessarily provide all the features of Oracomm's chat, but it
; does provide all the common functionality in as close a presentation as
; possible.
;
; This control file does require Oracomm style entry mode, so use a /E:1
; in the Opt Data of UltraChat when you invoke this control file.
;
; ----- HEADER ------------------------------------------------------
;
; ** CHANGE FOR YOUR OWN NEEDS **
;
SYSTEM_NAME_TEXT "Test Ultra-Chat System"
SYSTEM_ID_TEXT "UltraTst"
SYSOP_NAME_TEXT "The SysOp"
UCHAT_DIR SLASHT
;
; ----- STYLE AND GENERAL -------------------------------------------
;
NEW_USERS_NUM   10
MIN_CHANNEL_NUM 1
MAX_CHANNEL_NUM 9
ANNOUNCE_CHARS_NUM 30
LIST_ME_SWITCH ON
HOT_KEYS NO_DISPLAY
;
; ----- ORACOMM STYLE COMMANDS IN ALPHA ORDER -----------------------
;
; Announce command (set announce string)
;
EDIT#01_CMD    /ANNOUNCE   MODE=ABCD           ;/ANNOUNCE
   EDIT#01_PROMPT "Input 30 characters of text to use on /WO display:^M"
;
; Bring command (chat with another user)
;
CHAT#01_CMD    /BRING      MODE=ABCD           ;/BRING
  CHAT#01_PROMPT "Which ACCT?  "
  CHAT#01_EXIT   "%RUSER:C% left the channel.^M"
  CHAT#01_REMOTE "^G%RUSER:C%: (psst!) I want to chat.  Press C from the menu to go to chat (type '/P %RUSER:C%' if already in chat).^M"
  CHAT#01_NOCHAT "^MSorry, but that user asked not to be disturbed!^M"
  CHAT#01_SELF   "Sorry, but you can't do that to yourself!^M"
;
; Call command (different form of chatting with another user)
;
CHAT#02_CMD    /CALL       MODE=ABCD           ;/CALL
  CHAT#02_PROMPT =CHAT#01_PROMPT
  CHAT#02_EXIT   =CHAT#01_EXIT
;
; Exit chat
;
EXIT#01_CMD    /EXIT       MODE=BCD  EXACT     ;/EXIT
;
; Help file display
;
HELP#01_CMD    /HELP       MODE=ABCD EXACT     ;/HELP
   HELP#01_FILE  ORAHELP.TXT
   HELP#01_ERROR "Help file not found!^M"
;
; Invisible status toggle
;
TOGGLE#01_CMD  /INVISI     MODE=ABCD EXACT     ;/INVISI
   TOGGLE#01_OFF "^MYou are now VISIBLE.  Use /I to become INVISIBLE.^M^M"
   TOGGLE#01_ON  "^MYou are now INVISIBLE.  Use /I to become VISIBLE.^M^M"
;
; No chat mode toggle
;
TOGGLE#02_CMD  /NOCHAT     MODE=ABCD EXACT     ;/NOCHAT
   TOGGLE#02_OFF "^MYou are now in CHAT mode.  Use /N to go to NOCHAT mode.^M^M"
   TOGGLE#02_ON  "^MYou are now in NOCHAT mode.  Use /N to go to CHAT mode.^M^M"
;
; Three-line bio commands
;
BIO#02_CMD     /OPTIONS    MODE=ABCD EXACT     ;/OPTIONS
   BIO#01_PROMPT "Before you proceed, you MUST fill out the three line bio.  The
      +    | more interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines) of
      +    | text to use.  Do not press <Enter> until you are done!  Word
      +    | wrapping happens automatically.  Start typing: ^M^M"
   BIO#02_PROMPT "You are about to change your three line bio.  The more 
      +    | interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines)
      +    | of text to use.  Do not press <Enter> until you are done!
      +    |  Word wrapping happens automatically.  Start typing: ^M^M"
   BIO#02_YN "Are you sure you want to change your three line bio (Y/N)? "
;
; Private command, synonym for bring command (above)
;
CHAT#01_CMD    /PRIVATE    MODE=ABCD           ;/PRIVATE (same as /BRING)
;
; Send a message to another user
;
PRIVATE#01_CMD /TO         MODE=ABCD           ;/TO
   PRIVATE#01_REMOTE  "^G%RUSER:C%: (psst!) %RMSG%^M"
   PRIVATE#01_CONFIRM "Sent to %RUSER:C% only: %MSG%^M"
   PRIVATE#01_NAMEPMT "Which ACCT?  "
   PRIVATE#01_MSGPMT  "Input up to 2 lines of text to send to %RUSER:C%:^M^M"
   PRIVATE#01_NOCHAT  "^MSorry, but that user asked not to be disturbed!^M"
   PRIVATE#01_ERROR   "^MThat user cannot be interrupted right now.^M^M"
;
; Exit from private chat
;
EXIT#02_CMD    /UNPRIVATE  MODE=B    EXACT     ;/UNPRIVATE
;
; Short form announce
;
EDIT#01_CMD    /A          MODE=ABCD           ;/ANNOUNCE
;
; Short form bring
;
CHAT#01_CMD    /B          MODE=ABCD           ;/BRING
;
; Short form call
;
CHAT#02_CMD    /C          MODE=ABCD           ;/CALL
;
; Short form exit
;
EXIT#01_CMD    /E          MODE=BCD  EXACT     ;/EXIT
;
; Short form help
;
HELP#01_CMD    /H          MODE=ABCD EXACT     ;/HELP
;
; Short form invisible
;
TOGGLE#01_CMD  /I          MODE=ABCD EXACT     ;/INVISI
;
; Channel change command
;
CHANNEL#01_CMD /L          MODE=CD             ;/Ln
   CHANNEL#01_CHANPMT "Which CHANNEL would you like (%MINCHANNEL%-%MAXCHANNEL%)? "
   CHANNEL#01_BADNUM  "Channel number out of range %MINCHANNEL%-%MAXCHANNEL% - channel not changed.^M"
   CHANNEL#01_NOTNUM  "Invalid number entered - channel not changed.^M"
   CHANNEL#01_ENTRY   "%RUSER:C% entered the channel.^M"
   CHANNEL#01_EXIT    "%RUSER:C% left the channel.^M"
   CHANNEL#01_CONFIRM "Use /WC to list users on this channel, /H for help.^M"
;
; No chat short form
;
TOGGLE#02_CMD  /N          MODE=ABCD EXACT     ;/NOCHAT
;
; Three-line bio (options) short form
;
BIO#02_CMD     /O          MODE=ABCD EXACT     ;/OPTIONS
;
; Private short form
;
CHAT#01_CMD    /P          MODE=ABCD           ;/PRIVATE (same as /BRING)
;
; To short form
;
PRIVATE#01_CMD /T          MODE=ABCD           ;/TO
;
; Unprivate short form
;
EXIT#02_CMD    /U          MODE=B    EXACT     ;/UNPRIVATE
;
; Who is online command (long form who)
;
WHO#02_CMD     /WOL        MODE=ABCD EXACT     ;/WOL
   WHO#02_HEADER "Users Currently Online^M"
   WHO#02_NORMAL "%RUSER:8C%  %RLOCATION:20C% Logins %RLOGINS:5% Time %RTIMEUSED:7% Last on %RLASTON%^M%RFLAGS%^@   %R3LINEBIO%^M^@   Line: %RLINE:2%  Command: %RCOMMAND%^M^M"
   WHO#02_INVISIBLE "THIS USER IS CURRENTLY INVISIBLE^M^@   Line:%RLINE:+3%^M"
   WHO#02_TOTAL "  %LISTED% of %LASTLINE% lines in use.^M^M"
;
; Who is online command (short form)
;
WHO#01_CMD     /WO         MODE=ABCD EXACT     ;/WO
   WHO#01_HEADER "Users Currently Online^M
         +        Line Account   Location                 Command  Announcement^M"
   WHO#01_NORMAL " %RLINE:+2%  %RUSER:8C%  %RLOCATION:24C% %RCOMMAND:8% %RANNOUNCE:30%^M"
   WHO#01_INVISIBLE " %RLINE:+2%  THIS USER IS CURRENTLY INVISIBLE^M"
   WHO#01_TOTAL "^M^@ %LISTED% of %LASTLINE% lines in use.^M^M"
;
; Look-up a three-liner for a user (who is, who account)
;
WHO#10_CMD     /WI         MODE=ABCD           ;/WI
WHO#10_CMD     /WA         MODE=ABCD           ;/WA (same as /WI)
   WHO#10_NAMEPMT "Which ACCT?  "
   WHO#10_NORMAL  "%UUSER:8C%  %ULOCATION:20C% Logins %ULOGINS:5% Time %UTIMEUSED:7% Last on %ULASTON%^M%UFLAGS%^@   %U3LINEBIO%^M^M"
   WHO#10_ERROR   "^MThere is no such ACCT on this system.^M"
;
; List users in reverse order (who backward)
;
WHO#11_CMD     /WB         MODE=ABCD           ;/WB
   WHO#11_PAUSE  "^LPress S to Stop, P to Pause ^M^M"
   WHO#11_NORMAL =WHO#10_NORMAL
;
; List users in forward order (who forward)
;
WHO#12_CMD     /WF         MODE=ABCD           ;/WF
   WHO#12_PAUSE  =WHO#11_PAUSE
   WHO#12_NORMAL =WHO#10_NORMAL
;
; List new users (who new)
;
WHO#13_CMD     /WN         MODE=ABCD EXACT     ;/WN
   WHO#13_PAUSE  =WHO#11_PAUSE
   WHO#13_NORMAL =WHO#10_NORMAL
;
; List users on this channel (who channel)
;
WHO#07_CMD     /WC         MODE=BCD  EXACT     ;/WC
   WHO#07_PUBLIC "^MUsers on public channel #%CHANNEL%:^M^M
      +        Line Account   Location                  Announcement^M"
   WHO#07_PRIVATE "You are in private chat with %RUSER:C% on line %RLINE%^M"
   WHO#07_NORMAL " %RLINE:+2%  %RUSER:8C%  %RLOCATION:24C%  %RANNOUNCE:30%^M"
;
;
; The next string gets displayed if a users has the (F) full access flag
; set in their userlog image.  This was originally done for Ken's system
; and would tell the user that a GIF was on file for download.
;
USER#01_TEXT "^@ User has the full access flag set.^M"
;
; The next string gets displayed if a users has the (R) reviewed flag
; set in their userlog image.
;
USER#02_TEXT "^@ User has the reviewed flag set.^M"
;
; The next string gets displayed if a users has the (K) keep flag
; set in their userlog image.
;
USER#03_TEXT "^@ User has the keep flag set.^M"
;
; The next string gets displayed in a WO display if the user has used
; the /N command to get into NOCHAT mode.
;
USER#04_TEXT "I don't want to chat now"
CHAT#02_TEXT " %RLINE:2%  %RUSER:8C%^M"
;
; Sent for a public message
;
CHAT#01_TEXT "%RUSER:C%: %RMSG%^M"
;
; Prefix for public messages coming across
;
CHAT#23_TEXT "^M"
;
; Error strings
;
ERROR#01_TEXT "Unrecognized command.  Type /H for Help.^M"
ERROR#02_TEXT "That ACCT is not currently logged on.^M"
ERROR#03_TEXT "That ACCT refers to multiple users.^M"
ERROR#04_TEXT "^MW commands are not allowed while you are invisible.^M^M"
ERROR#05_TEXT "^MSorry, but that user asked not to be disturbed!^M"
ERROR#06_TEXT "Sorry, but you can't do that to yourself!^M"
ERROR#07_TEXT "That ACCT can refer to multiple users, if you wish to send
      +    | to a specific user, end the ACCT with a : for example 'SYSOP:' or
      +    | '%USER:C%:'^M"
;
; Chat entry header when people are waiting
;
CHAT#03_TEXT "The following user(s) are waiting to chat with you:^M^M"
;
; Prompt when only one user is waiting to chat
;
CHAT#04_TEXT "Would you like to go into private chat with this user (Y/n)? "
;
; Prompt when several people are waiting to chat
;
CHAT#05_TEXT "Enter the line number of the person that you want to chat with,
      +    | or C to enter chat with someone else: "
;
; Prompt for getting into chat with no one waiting
;
CHAT#06_TEXT "Enter the line number of the person that you want to chat with,
      +    | C for chat with everyone, or X to exit: "
;
; Prompt asking if a user wants to wait for a chat to start
;
CHAT#07_TEXT "^MDo you wish to wait for the other user (Y/n)? "
;
; Prompt telling the user they are waiting
;
CHAT#08_TEXT "^MYou are now waiting for the other user.  A period will appear
      +      | every 5 seconds while you wait.  Press the <Enter> key at any
      +      | time to stop waiting for the other user.^M^M"
;
; Tells the user that the other person in the private chat has left
;
CHAT#09_TEXT "^M^MThe other person left.  You are exiting chat now.^M^M"
;
; Tells the user they are in private chat now
;
CHAT#10_TEXT "You are now in private chat.  Use /E to exit.^M^M"
;
; Tells the user they are in public chat
;
CHAT#11_TEXT "Use /WC to list users on this channel, /H for help.^M"
;
; Private chat prompt
;
CHAT#12_TEXT "P: "
;
; Public chat prompt
;
CHAT#13_TEXT ": "
CHAT#20_TEXT =CHAT#13_TEXT
CHAT#21_TEXT =CHAT#13_TEXT
CHAT#22_TEXT =CHAT#13_TEXT
;
; Sent when a user enters a channel
;
CHAT#14_TEXT "%RUSER:C% entered the channel.^M"
;
; Sent when a user leaves a channel
;
CHAT#15_TEXT "%RUSER:C% left the channel.^M"
CHAT#19_TEXT =CHAT#15_TEXT
;
; Tells user that no /T messages are available (used when /QD is on Opt Data)
;
MISC#01_TEXT "No /T messages waiting for you.^M"
;
; Wait for keypress
;
MISC#02_TEXT "Press any key to continue..."
;
; User just logged in
;
MISC#03_TEXT "%RUSER:C%: Just logged in.^M"
;
; Banner for entry to chat
;
MISC#09_TEXT "^[[0;1;37mWelcome to %VERSION% in Oracomm emulation mode!^M^M"
;
; The user you're waiting on left
;
CHAT#24_TEXT "^MThe user you are waiting for is no longer logged on, exiting wait mode.^M"
;
;
